<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Generador de Tablas</title>
    <link rel="stylesheet" href="css.css">
</head>

<body>

    <?php
    $numero = 1;
    $cantidad = 10;
    if (isset($_POST['numero'])) {
        $numero = $_POST['numero'];
        $cantidad = $_POST['cantidad'];
    }
    ?>

    <form action="index.php" method="post">
        <input type="number" name="numero" placeholder="Tabla del:" required min="2">
        <input type="number" name="cantidad" placeholder="Cantidad:" required min="2" value="<?php echo $cantidad; ?>">
        <input type="submit" value="Crear">
    </form>



    <h1>Cantidad Actual: <?php echo $cantidad; ?></h1>

    <table class="minimalistBlack" <caption>Tabla del: <?php echo $numero; ?></caption>
        <tbody>
            <?php for ($i = 1; $i <= $cantidad; $i++) { ?>
                <tr>
                    <td><?php echo $numero; ?></td>
                    <td>X</td>
                    <td><?php echo $i; ?></td>
                    <td>=</td>
                    <td><?php echo $numero * $i; ?></td>
                </tr>
            <?php } ?>
        </tbody>
    </table>

    <h2>Triángulo Recto</h2>
    <?php
    for ($f = 1; $f <= $cantidad; $f++) {
        for ($c = 1; $c <= $f; $c++) {
            echo "*";
        }
        echo "<br>";
    }
    ?>

    <h2>Triángulo</h2>
    <?php
    for ($f = 1; $f <= $cantidad; $f++) {
        for ($c = 1; $c <= $cantidad - $f; $c++) {
            echo "&nbsp&nbsp";
        }
        for ($c = 1; $c <= $f; $c++) {
            echo "&#x25B2;";
        }
        echo "<br>";
    }
    ?>


    <h2>Rombo</h2>
    <?php
    for ($f = 1; $f <= $cantidad; $f++) {
        for ($c = 1; $c <= $cantidad - $f; $c++) {
            echo "&nbsp";
        }
        for ($c = 1; $c <= $f; $c++) {
            echo "*";
        }
        echo "<br>";
    }
    for ($f = 1; $f <= $cantidad; $f++) {
        for ($c = 1; $c <= $f; $c++) {
            echo "&nbsp";
        }
        for ($c = 1; $c <= $cantidad - $f; $c++) {
            echo "*";
        }
        echo "<br>";
    }
    ?>

    <h2>Quiniela</h2>
    <?php
    $contador = 1;
    $valores = [1, "X", 2]; //array
    for ($i1 = 0; $i1 <= 2; $i1++) {
        for ($i2 = 0; $i2 <= 2; $i2++) {
            for ($i3 = 0; $i3 <= 2; $i3++) {
                for ($i4 = 0; $i4 <= 2; $i4++) {
                    for ($i5 = 0; $i5 <= 2; $i5++) {
                        echo "<strong>POSIBILIDAD " . $contador++ . ":  </strong>" .  $valores[$i1] . " " . $valores[$i2] . " " . $valores[$i3] . " " . $valores[$i4] .  " " . $valores[$i5] . "</br>";
                    }
                }
            }
        }
    }
    ?>


    <h2>Ajedrez</h2>
    <table class="ajedrez">
        <?php
        for ($f = 1; $f <= $cantidad; $f++) {
            echo "<tr>";
            for ($c = 1; $c <= $cantidad; $c++) {
                echo "<td>&#9818;</td>";
            }
            echo "</tr>";
        }
        ?>
    </table>


    <h2>Ajedrez</h2>
    <table class="ajedrez2">
        <?php
        $iterador = 1;
        for ($f = 1; $f <= $cantidad; $f++) {
            echo "<tr>";
            for ($c = 1; $c <= $cantidad; $c++) {
                $class = "";
                if ($iterador % 2 == 0) {
                    $class = "oscuro";
                }
                echo "<td class='" . $class . "'>" . $iterador . "</td>";
                ++$iterador;
            }
            ++$iterador;
            echo "</tr>";
        }
        ?>
    </table>

    <h2>Divisibles</h2>
    <?php
        for ($n=1; $n <= 1000 ; $n++) { 
            if($n % 3 == 0){
                echo $n . "</br>"; 
            }
        }

        $n = 1;
        while ($n <= 1000) {
            if($n % 3 == 0){
                echo $n . "</br>"; 
            }
            $n++;
        }
    ?>
</body>

</html>