<?php
require_once("includes/categorias.php");
require_once("includes/productos.php");
$categoria = 5;
if (isset($_GET['cat'])) {
    $categoria = $_GET['cat'];
}
?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tienda</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css">
    <link rel="stylesheet" href="css.css">
    <link rel="stylesheet" href="css_mobile.css" media="screen and (max-width: 450px)">
</head>

<body>
    <header>
        <nav>
            <ul class="ul_horizontal">
                <li><a href="#">Lorem.</a></li>
                <li><a href="#">Temporibus!</a></li>
                <li><a href="#">Libero!</a></li>
                <li><a href="#">Distinctio.</a></li>
                <li><a href="#">Magni.</a></li>
            </ul>
        </nav>
        <div id="buscador">
            <div>
                <input type="search" id="buscar">
                <i class="fa-solid fa-magnifying-glass"></i>
            </div>
        </div>
    </header>
    <main>
        <pre>
        <?php
        //print_r($productos)
        ?>
        </pre>
        <ul class="ul_horizontal">
            <?php
            foreach ($productos[$categoria] as $key => $value) {
            ?>
                <li>
                    <div class="producto">
                        <h2><?php echo $value["titulo"]; ?></h2>
                        <?php
                        $fichero = $categoria . "_" . $key;
                        $fichero = __DIR__ . "/img/" . $fichero . ".jpg";
                        if (file_exists($fichero)) {
                            echo '<img src="./img/' . $categoria . '_' . $key . '.jpg" alt="Foto">';
                        } else {
                            echo '<img src="img/noimg.jpg" alt="Foto">';
                        }
                        ?>
                        <p><?php echo $value["resumen"]; ?></p>
                        <a href="vermas.html"><?php echo $value["precio"]; ?></a>
                    </div>
                </li>
            <?php
            }
            ?>
        </ul>
    </main>
    <section id="categorias">
        <h3>Categorías</h3>
        <nav>
            <ul>
                <?php
                foreach ($categorias as $key => $value) {
                    echo "<li><a href='index.php?cat=" . $key . "'>" . $value . "</a></li>\n";
                }
                ?>


            </ul>
        </nav>
    </section>
    <footer>
        <p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Magni, temporibus. Recusandae iste maiores dolorem
            quia perferendis veniam sed placeat, exercitationem id ipsam nam sint ratione ex saepe nulla dolor corrupti.
        </p>
        <nav>
            <ul class="ul_horizontal">
                <li><a href="#">Lorem.</a></li>
                <li><a href="#">Dolores!</a></li>
                <li><a href="#">Maiores!</a></li>
                <li><a href="#">Voluptatibus.</a></li>
                <li><a href="#">Molestias!</a></li>
            </ul>
        </nav>
    </footer>
</body>

</html>