<?php
function Resolver(&$tablero){
    static $reinas = 0;
    for ($f = 0; $f < count($tablero[0]); $f++){
        for ($c = 0; $c < count($tablero[0]); $c++)
        {
            if ($tablero[$f][$c] == 0)
            {
                $reinas++;
                Marcar($tablero, $f, $c, 1);
                Resolver($tablero);
                if ($reinas == count($tablero[0])) // RESUELTO
                {
                    return;
                }
                $reinas--;
                Marcar($tablero, $f, $c, -1);
            }
        }
    }
}

function Marcar(&$tablero, $f, $c, $marcar){
    // filas y columnas
    for ($ff = 0; $ff < count($tablero[0]); $ff++)
    {
        $tablero[$f][$ff] += $marcar;
        $tablero[$ff][$c] += $marcar;
    }
    // diagolanes

   $fi = 0; 
   $ci = 0; 
   $correr = 0;
    if ($f <= $c)
    {
        $fi = 0;
        $ci = $c - $f;
    }
    else
    {
        $ci = 0;
        $fi = $f - $c;
    }
    $correr = count($tablero[0]) - $fi - $ci;
    for ($i = 1; $i <= $correr; $i++)
    {
        $tablero[$fi++][$ci++] += $marcar;
    }

    // diagolanes /
    $fi = $f;
    $ci = $c;
    while ($fi < count($tablero[0]) - 1 && $ci > 0)
    {
        $fi++;
        $ci--;
    }
    $correr = $fi + 1 - $ci;
    // qDebug() << correr << "-" << fi << "-" << ci;
    for ($i = 1; $i <= $correr; $i++)
    {
        $tablero[$fi--][$ci++] += $marcar;
    }

    if ($marcar == 1)
    {
        $tablero[$f][$c] = -1;
    }
    else
    {
        $tablero[$f][$c] = 0;
    }
}

?>


<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Juego de las X Reinas en tablero de x * x</title>

    <style>
        table.ajedrez {
            border: solid 1px black;
            border-spacing: 0px;
            border-collapse: collapse;
            text-align: center;
        }

        table.ajedrez td {
            width: 40px;
            height: 40px;
            border: 0px;
            padding: 0px;
        }

        table.ajedrez tr:nth-child(even) td:nth-child(odd),
        table.ajedrez tr:nth-child(odd) td:nth-child(even) {
            background-color: #000000;
            color: #ffffff;
        }
    </style>
</head>

<body>
        <form action="index.php" method="post">
            <input type="number" name="cantidad" required min="4" max="13">
            <input type="submit" value="Enviar">
        </form>
    <?php
    $tablero;

    if(isset($_POST["cantidad"]) && is_numeric($_POST["cantidad"]) && $_POST["cantidad"] >= 4 && $_POST["cantidad"] <=13){
        $cantidad = $_POST["cantidad"];
        for ($f = 0; $f < $cantidad; $f++) {
            for ($c = 0; $c < $cantidad; $c++) {
                $tablero[$f][$c] = 0;
            }
        }
        Resolver($tablero);
    ?>    
    <h2>Ajedrez de <?php echo $cantidad . " X " . $cantidad; ?></h2>
    <table class="ajedrez">
        <?php
        for ($f = 1; $f <= $cantidad; $f++) {
            echo "<tr>";
            for ($c = 1; $c <= $cantidad; $c++) {
                $reina = "";
                if($tablero[$f-1][$c-1] == -1){
                    $reina = "♛";
                }
                echo "<td>".$reina."</td>";
            }
            echo "</tr>";
        }
        ?>
    </table>
    <?php
    } 
    ?>

</body>

</html>