<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Radio ONline</title>
    <link rel="stylesheet" href="css.css">
    <script src="https://code.jquery.com/jquery-3.6.4.js" integrity="sha256-a9jBBRygX1Bh5lt8GZjXDzyOB+bWve9EiO7tROUtj/E=" crossorigin="anonymous"></script>
    <script>
        function verRadiosPaises() {
            let pais = $("#paises").val();
            //let pais = document.getElementById("paises").value;

            $.getJSON("radiospaises.php?id=" + pais,
                function(data, textStatus, jqXHR) {
                    let html = "";
                    let generoshtml = '<option value="">Generos...</option>';
                    let generos = [];

                    data.stations.map(function(estacion) {
                        html += `<div class="${estacion.genre}">
                                    <img src="${estacion.radio_image}">
                                    <h2>${estacion.radio_name}, <span class="naranja2">${estacion.genre}</span></h2>
                                    <button class="boton" onclick="escuchar('${estacion.radio_url}', '${estacion.radio_name}')">Escuchar</button>
                                </div>`;
                        if (generos.includes(estacion.genre) == false) {
                            generos.push(estacion.genre);
                            generoshtml += `<option value="${estacion.genre}">${estacion.genre}</option>`;
                        }
                    });
                    $("#radios").html(html);
                    $("#generos").html(generoshtml);
                }
            );
        }

        function escuchar(url, title) {
            window.open(url, title, 'toolbar=0,scrollbars=0,location=0,statusbar=0,menubar=0,resizable=1,width=300,height=200,left = 390,top = 50');
        }


        function verRadiosGeneros() {
            let genero = $("#generos").val();
            $("#radios div").hide();
            $("." + genero).show();
        }
    </script>

</head>



<body>
    <header>
        <select id="paises" onchange="verRadiosPaises()">
            <option value="">Paises</option>
            <?php
            $paises = [];
            $paises = json_decode(file_get_contents("paises.json"), true);
            foreach ($paises['countries'] as $key => $value) {
                echo "<option value='" . $value['country_id'] . "'>" . $value['country_name'] . "</option>";
            }
            ?>
        </select>
        <select id="generos" onchange="verRadiosGeneros()">

        </select>
    </header>

    <main>
        <h1>Listado de Estadios</h1>

        <div id="radios">

        </div>
    </main>
</body>

</html>