<?php
ob_start();
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Películas de la Semana</title>
    <style>
        body {
            background-color: black;
            font-family: Arial, Helvetica, sans-serif;
        }

        ul {
            margin: 0px;
            margin: auto;
            padding: 0px;
            list-style: none;
            max-width: 90%;
            display: grid;
            grid-template-columns: 1fr 1fr 1fr 1fr;
            gap: 10px;
        }

        ul li {
            text-align: center;
            color: gainsboro;
            font-size: 0.8em;
        }

        ul li a {
            text-decoration: none;
            color: gainsboro;
        }

        ul li:hover {
            opacity: 0.8;
        }

        ul li img {
            max-width: 98%;
            border-radius: 3px
        }


        @media (max-width: 600px) {
            ul {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>

<body>

    <?php
    echo "<ul>";
    $json = json_decode(file_get_contents("https://api.themoviedb.org/3/trending/movie/week?api_key=4b1d0a5f84ffaab37951c016c1684ff6&language=es"), true);
    //print_r($json);
    foreach ($json["results"] as $key => $value) {
        echo "<li><a href='pelicula.php?id=" . $value['id'] . "'><img src='https://image.tmdb.org/t/p/w300" . $value['poster_path'] . "'/><br>" . $value['title'] . "<br>" . $value['release_date'] . "<br>PUNTOS: " . $value['vote_average'] . "</a></li>";
    }
    echo "<ul>";
    ?>

</body>

</html>


<?php
$cachelink =  __DIR__ . '/index.html';
if(count($json["results"]) > 0){
    file_put_contents($cachelink, ob_get_contents());
}
ob_end_flush();
?>