<?php
require_once("includes/categorias.php");
require_once("includes/usuarios.php");
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mi Lista de la Compra</title>
    <link rel="stylesheet" href="assets/css.css">

    <script src="assets/js.js"></script>

    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
    <script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
</head>

<body>
    <h1>Mi Lista de la Compra</h1>

    <main>
        <?php
        $usuario = "";
        if (isset($_COOKIE["usuario"])) {
            foreach ($usuarios as $key => $value) {
                if ($key == $_COOKIE["usuario"]) {
                    $usuario = $key;
                }
            }
        }

        if ($usuario != "") {
        ?>
            <p style="text-align: right; font-size: 2em; margin: 0px; padding: 0px;">
                <a href="includes/salir.php"><ion-icon name="exit-outline"></ion-icon></a>
            </p>
            <form action="includes/nuevo.php" method="post">
                <input type="text" name="producto" id="producto" required>
                <button type="button" onclick="reconocerVoz()" id="micro">
                    <ion-icon name="mic-outline"></ion-icon>
                </button>
                <select name="categoria" required>
                    <option value="">Seleccione...</option>
                    <?php
                    asort($categorias);
                    foreach ($categorias as $key => $value) {
                        echo '<option value="' . $key . '">' . $value . '</option>';
                    }
                    ?>
                </select>
                <button type="submit">
                    <ion-icon name="add-outline"></ion-icon>
                </button>
            </form>

            <?php
            if (file_exists(__DIR__ . "/includes/productos/" . $usuario . ".txt")) {
                $productos = unserialize(file_get_contents(__DIR__ . "/includes/productos/" . $usuario . ".txt"));
                foreach ($categorias as $key => $value) {
                    if (isset($productos[$key]) && count($productos[$key]) > 0) {
                        echo "<h2>" . $value . "</h2><ul>";
                        natcasesort($productos[$key]);
                        foreach ($productos[$key] as $keyp => $valuep) {
                            echo '<li><a href="./includes/borrar.php?cat=' . $key . '&key=' . $keyp . '"><ion-icon name="cart-outline" class="iconos"></ion-icon></a>' . $valuep . '</li>';
                        }
                        echo "</ul>";
                    }
                }
            } else {
                echo "<p><strong>De momento no tiene productos en la Cesta</strong></p>";
            }
        } else {
            if(isset($_GET['e']) && $_GET['e'] == 1){
                echo '<h2><ion-icon name="alert-circle-outline"></ion-icon> ERROR: NO EXISTE USUARIO CON ESTAS CREDENCIALES</h2>';
            }
            ?>

            <form action="includes/login.php" method="post">
                <input type="text" name="usuario" placeholder="usuario" required>
                <br>
                <input type="password" name="pass" placeholder="pass" required>
                <br>
                <input type="submit" value="Entrar">
            </form>
        <?php
        }
        ?>
    </main>
</body>

</html>