<?php
$title = "Gestión de Productos";
include_once("arriba.php");
$clave = generarclave();
setcookie("envio", $clave, time() + (10 * 60), "/");
?>
<div>
    <a class="boton" href="nuevo_producto.php"><i class="fa-solid fa-square-plus"></i> Añadir Producto</a>
</div>
<section>

    <h2>Productos:</h2>

    <table id="myTable" class="display">
        <thead>
            <tr>
                <th>ID</th>
                <th>Producto</th>
                <th>Categoría</th>
                <th>Marca</th>
                <th>Stock</th>
                <th>iva</th>
                <th>Precio</th>
                <th>Editar</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $resultado = $mysqli->query("SELECT productos.id, productos.producto, productos.precio, productos.stock, ivas.iva, marcas.marca, categorias.categoria from productos, ivas, marcas, categorias where productos.categoria = categorias.id and productos.marca = marcas.id and productos.iva = ivas.id order by productos.id DESC");
            while ($fila = $resultado->fetch_assoc()) {
            ?>
                <tr>
                    <td><?php echo $fila['id']; ?></td>
                    <td><?php echo $fila['producto']; ?></td>
                    <td><?php echo $fila['categoria']; ?></td>
                    <td><?php echo $fila['marca']; ?></td>
                    <td><?php echo $fila['stock']; ?></td>
                    <td><?php echo $fila['iva']; ?></td>
                    <td><input onchange="editarPrecio(<?php echo $fila['id'] ?>, '<?php echo base64_encode($GLOBALS['clave']); ?>', $(this).val())" type="number" name="" value="<?php echo $fila['precio']; ?>"></td>
                    <td><button onclick="editarProducto(<?php echo $fila['id']; ?>)"><i class="fa-solid fa-pen-to-square"></i> Editar</button></td>
                </tr>
            <?php
            }
            ?>

        </tbody>
    </table>

    <script>
        let table = new DataTable('#myTable', {
            "language": {
                url: '//cdn.datatables.net/plug-ins/1.13.3/i18n/es-ES.json',
            },
            "pageLength": 100,
            "order": [[ 0, 'desc' ], [ 1, 'asc' ]]
        });
    </script>

</section>

<?php include_once("abajo.php"); ?>