<?php
$title = "Gestión de Pedidos";
include_once("arriba.php");
$clave = generarclave();
setcookie("envio", $clave, time() + (10 * 60), "/");
$estados = ["Reciente", "En Preparación", "En Reparto", "Cobrado"];
?>
<section>

    <h2>Pedidos</h2>

    <table id="myTable" class="display">
        <thead>
            <tr>
                <th>ID</th>
                <th>DNI/CIF</th>
                <th>Nombre</th>
                <th>Fecha</th>
                <th>Telefono</th>
                <th>Correo</th>
                <th>Direccion</th>
                <th>Población</th>
                <th>CP</th>
                <th>Estado</th>
                <th>Importe</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $resultado = $mysqli->query("SELECT * from vista_pedidos where estado < 3");
            while ($fila = $resultado->fetch_assoc()) {
            ?>
                <tr>
                    <td><?php echo $fila['id']; ?></td>
                    <td><?php echo $fila['dni']; ?></td>
                    <td><a href="editar_pedidos.php?id=<?php echo $fila['id']; ?>"><?php echo $fila['nombre'] . " " . $fila['apellidos']; ?></a></td>
                    <td><?php echo $fila['fecha']; ?></td>
                    <td><?php echo $fila['telefono']; ?></td>
                    <td><?php echo $fila['correo']; ?></td>
                    <td><?php echo $fila['direccion']; ?></td>
                    <td><?php echo $fila['poblacion']; ?></td>
                    <td><?php echo $fila['cp']; ?></td>
                    <td>
                        <select onchange="cambiarEstado(<?php echo $fila['id']; ?>);" name="estado" id="estado_<?php echo $fila['id']; ?>">
                            <?php
                            foreach ($estados as $key => $value) {
                                $selected = "";
                                if ($key == $fila['estado']) {
                                    $selected = "selected";
                                }
                                echo '<option ' . $selected . ' value="' . $key . '">' . $value . '</option>';
                            }
                            ?>
                        </select>
                    </td>
                    <td><?php echo $fila['importe']; ?></td>
                </tr>
            <?php
            }
            ?>

        </tbody>
    </table>

    <script>
        let table = new DataTable('#myTable', {
            "language": {
                url: '//cdn.datatables.net/plug-ins/1.13.3/i18n/es-ES.json',
            },
            "pageLength": 100,
            "order": [
                [0, 'desc'],
                [1, 'asc']
            ]
        });
    </script>

</section>

<?php include_once("abajo.php"); ?>