<?php
$title = "Nuevo Productos";
include_once("arriba.php");
$clave = generarclave();
setcookie("envio", $clave, time() + (10 * 60), "/");
?>
<div>
    <a class="boton" href="productos.php"><i class="fa-solid fa-list"></i> Listado Productos</a>
</div>
<section>

    <?php
    if (isset($_GET['error'])) {
        if ($_GET['error'] === "true") {
            echo '<div id="alertas" class="ko"><i class="fa-solid fa-circle-exclamation"></i> Se ha producido un error en la operación..</div>';
        } else {
            echo '<div id="alertas" class="ok"><i class="fa-solid fa-check"></i> Operación Correcta</div>';
        }
    }
    ?>
    <script src="https://cdn.tiny.cloud/1/cqd5we7v96awl0waoo8iqiw30wrntutc7dvo2lhzh0zcmqfy/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
    <script>
        tinymce.init({
            selector: 'textarea',
            language: 'es',
            plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
            toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
        });
    </script>
    <form enctype="multipart/form-data" action="includes/guardar_producto.php" method="post">
        <fieldset>
            <legend>Nuevo Producto:</legend>
            <input type="hidden" name="seguridad" value="<?php echo base64_encode($GLOBALS['clave']); ?>">
            <input class="input input100" type="text" name="producto" required placeholder="Producto">
            <textarea name="descripcion" class="input input100" rows="10" placeholder="Descripción"></textarea>

            <select name="marca" required class="input input20">
                <option value="">Marca</option>
                <?php
                $resultado = $mysqli->query("SELECT * FROM marcas ORDER BY marca ASC");
                while ($fila = $resultado->fetch_assoc()) {
                ?>
                    <option value="<?php echo $fila['id']; ?>"><?php echo $fila['marca']; ?></option>
                <?php
                }
                ?>
            </select>

            <select class="input input20" name="iva" required class="input input100">
                <option value="">Tipo De Iva</option>
                <?php
                $resultado = $mysqli->query("SELECT * FROM ivas ORDER BY iva ASC");
                while ($fila = $resultado->fetch_assoc()) {
                ?>
                    <option value="<?php echo $fila['id']; ?>"><?php echo $fila['iva']; ?>, <?php echo $fila['texto']; ?></option>
                <?php
                }
                ?>
            </select>

            <input class="input input20" type="number" name="precio" required min="0" placeholder="Precio €">
            <input class="input input20" type="text" name="unidad" required placeholder="Unidades (kg, gr, docenas)">
            <input class="input input20" type="text" name="cantidadminima" required placeholder="Cantidad Mínima" step="0.1">
            <select class="input input20" name="oferta" required class="input input100">
                <option value="0">Sin Oferta</option>
                <option value="1">En OFERTA</option>
            </select>
            <input class="input input20" type="number" name="stock" required min="0" placeholder="Stock Actual">
            <fieldset class="fondoclaro">
                <legend>Categorías:</legend>

                <?php
                pintarCategorias();

                function pintarCategorias($padre = 1)
                {
                    echo "<ul>";
                    $resultado = $GLOBALS['mysqli']->query("SELECT * FROM categorias where padre = $padre ORDER BY categoria ASC");
                    if ($padre == 1) {
                        $resultado = $GLOBALS['mysqli']->query("SELECT * FROM categorias where padre = $padre and id != 1 ORDER BY categoria ASC");
                    }

                    while ($fila = $resultado->fetch_assoc()) {
                        echo '<li>';
                ?>
                        <label><input type="radio" name="categoria" required value="<?php echo $fila['id']; ?>"><?php echo $fila['categoria']; ?></label>
                <?php
                        echo '</li>';
                        pintarCategorias($fila['id']);
                    }
                    echo "</ul>";
                }
                ?>
            </fieldset>

            <label><strong>Fotos:</strong> <input class="input input50" type="file" name="ficheros[]" multiple accept="image/*"></label>
            <button class="boton"><i class="fa-solid fa-floppy-disk"></i> Guardar Producto</button>

        </fieldset>
    </form>

</section>

<?php include_once("abajo.php"); ?>