<?php
$title = "Editar Producto";
include_once("arriba.php");
$clave = generarclave();
setcookie("envio", $clave, time() + (10 * 60), "/");
?>

<section>

    <?php
    $error = true;
    $producto;
    if (isset($_GET['id']) && is_numeric($_GET['id']) && $_GET['id'] > 0) {
        $id = $mysqli->real_escape_string($_GET['id']);
    }
    if ($resultado = $mysqli->prepare("SELECT * from productos where id = ? limit 1")) {
        $resultado->bind_param("i", $id);
        if ($resultado->execute()) {
            $result = $resultado->get_result(); // get the mysqli result
            if ($result->num_rows == 1) {
                $producto = $result->fetch_assoc();
                $error = false;
            }
        }
    }

    ?>

    <div class="flex">
        <a class="boton" href="productos.php"><i class="fa-solid fa-list"></i> Listado Productos</a>
        <?php
        if ($error == false) {
            $resultado = $mysqli->query("SELECT count(id) as total from ventas_detalles where producto = " . $producto['id']);
            $resultado = $resultado->fetch_assoc();
            if ($resultado['total'] == 0) {
                echo '<a class="boton" href="includes/borrar_producto.php?id=' . $producto['id'] . '&seguridad=' . urlencode(base64_encode($GLOBALS['clave'])) . '"><i class="fa-solid fa-trash-can"></i> Borrar</a>';
            }
        }
        ?>
    </div>

    <?php


    if ($error == true) {
        echo '<div id="alertas" class="ko"><i class="fa-solid fa-circle-exclamation"></i> ERROR, el id que está utilizando no es correcto</div>';
    }

    if (isset($_GET['error'])) {
        if ($_GET['error'] === "true") {
            echo '<div id="alertas" class="ko"><i class="fa-solid fa-circle-exclamation"></i> Se ha producido un error en la operación..</div>';
        } else {
            echo '<div id="alertas" class="ok"><i class="fa-solid fa-check"></i> Operación Correcta</div>';
        }
    }
    ?>

    <?php
    if ($error == false) {
    ?>
        <script src="https://cdn.tiny.cloud/1/cqd5we7v96awl0waoo8iqiw30wrntutc7dvo2lhzh0zcmqfy/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
        <script>
            tinymce.init({
                selector: 'textarea',
                language: 'es',
                plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
                toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
            });
        </script>
        <form action="includes/editar_producto.php" method="post">
            <fieldset>
                <legend>Editar Producto:</legend>
                <input type="hidden" name="seguridad" value="<?php echo base64_encode($GLOBALS['clave']); ?>">
                <input type="hidden" name="id" value="<?php echo $producto['id']; ?>">
                <input class="input input100" type="text" name="producto" required placeholder="Producto" value="<?php echo $producto['producto']; ?>">
                <textarea name="descripcion" class="input input100" rows="10" placeholder="Descripción"><?php echo $producto['descripcion']; ?></textarea>

                <select name="marca" required class="input input20">
                    <option value="">Marca</option>
                    <?php
                    $resultado = $mysqli->query("SELECT * FROM marcas ORDER BY marca ASC");
                    while ($fila = $resultado->fetch_assoc()) {
                        $selected = "";
                        if ($fila['id'] == $producto['marca']) {
                            $selected = "selected";
                        }
                    ?>
                        <option <?php echo $selected; ?> value="<?php echo $fila['id']; ?>"><?php echo $fila['marca']; ?></option>
                    <?php
                    }
                    ?>
                </select>

                <select class="input input20" name="iva" required class="input input100">
                    <option value="">Tipo De Iva</option>
                    <?php
                    $resultado = $mysqli->query("SELECT * FROM ivas ORDER BY iva ASC");
                    while ($fila = $resultado->fetch_assoc()) {
                        $selected = "";
                        if ($fila['id'] == $producto['iva']) {
                            $selected = "selected";
                        }
                    ?>
                        <option <?php echo $selected; ?> value="<?php echo $fila['id']; ?>"><?php echo $fila['iva']; ?>, <?php echo $fila['texto']; ?></option>
                    <?php
                    }
                    ?>
                </select>

                <input class="input input20" type="number" name="precio" required min="0" placeholder="Precio €" value="<?php echo $producto['precio']; ?>">
                <input class="input input20" type="text" name="unidad" required placeholder="Unidades (kg, gr, docenas)" value="<?php echo $producto['unidad']; ?>">
                <input class="input input20" type="text" name="cantidadminima" required placeholder="Cantidad Mínima" step="0.1" value="<?php echo $producto['cantidadminima']; ?>">
                <select class="input input20" name="oferta" required class="input input100">
                    <option <?php if($producto['oferta'] == 0){ echo "selected"; } ?> value="0">Sin Oferta</option>
                    <option <?php if($producto['oferta'] == 1){ echo "selected"; } ?>  value="1">En OFERTA</option>
                </select>
                <input class="input input20" type="number" name="stock" required min="0" placeholder="Stock Actual" value="<?php echo $producto['stock']; ?>">
                <fieldset class="fondoclaro">
                    <legend>Categorías:</legend>

                    <?php
                    function pintarCategorias($id, $padre = 1)
                    {
                        echo "<ul>";
                        $resultado = $GLOBALS['mysqli']->query("SELECT * FROM categorias where padre = $padre ORDER BY categoria ASC");
                        if ($padre == 1) {
                            $resultado = $GLOBALS['mysqli']->query("SELECT * FROM categorias where padre = $padre and id != 1 ORDER BY categoria ASC");
                        }

                        while ($fila = $resultado->fetch_assoc()) {
                            echo '<li>';
                            $checked = "";
                            if ($fila['id'] == $id) {
                                $checked = "checked";
                            }
                    ?>
                            <label><input <?php echo $checked; ?> type="radio" name="categoria" required value="<?php echo $fila['id']; ?>"><?php echo $fila['categoria']; ?></label>
                    <?php
                            echo '</li>';
                            pintarCategorias($id, $fila['id']);
                        }
                        echo "</ul>";
                    }

                    pintarCategorias($producto['categoria'], 1);
                    ?>
                </fieldset>

                <button class="boton"><i class="fa-solid fa-floppy-disk"></i> Guardar Producto</button>

            </fieldset>
        </form>
    <?php
    }
    ?>

    <fieldset>
        <legend>Fotos</legend>
        <div id="fotos">
            <?php
            $resultado = $mysqli->query("SELECT * from fotos where producto = " . $producto['id']);
            while ($foto = $resultado->fetch_assoc()) {
            ?>
                <div>
                    <a class="boton" href="includes/borrar_fotos.php?idfoto=<?php echo $foto['id'] ?>&idproducto=<?php echo $producto['id']; ?>&extension=<?php echo $foto['extension']; ?>&seguridad=<?php echo urlencode(base64_encode($GLOBALS['clave'])); ?>"><i class="fa-solid fa-trash-can"></i> Borrar Foto</a>
                    <img src="../fotos/<?php echo $foto['id'] ?>.<?php echo $foto['extension'] ?>" alt="Foto">
                </div>
            <?php
            }
            ?>
        </div>
        <form enctype="multipart/form-data" action="includes/anadir_fotos.php" method="post">
            <input type="hidden" name="seguridad" value="<?php echo base64_encode($GLOBALS['clave']); ?>">
            <input type="hidden" name="id" value="<?php echo $producto['id']; ?>">
            <label>Añadir Fotos: <input class="input input50" type="file" name="ficheros[]" multiple accept="image/*"></label>
            <button class="boton"><i class="fa-solid fa-file-image"></i> Añadir Fotos</button>
        </form>
    </fieldset>


</section>

<?php include_once("abajo.php"); ?>