<?php
$title = "Editar Pedido";
include_once("arriba.php");
$clave = generarclave();
setcookie("envio", $clave, time() + (10 * 60), "/");
$estados = ["Reciente", "En Preparación", "En Reparto", "Cobrado"];
$id = 0;
if (isset($_GET['id']) && is_numeric($_GET['id']) && $_GET['id'] > 0) {
    $id = $_GET['id'];
} else {
    header("Location: pedidos.php");
    exit();
}
$pedido = $mysqli->query("SELECT * from vista_pedidos where id = " . $id);
if ($pedido->num_rows == 1) {
    $pedido = $pedido->fetch_assoc();
} else {
    header("Location: pedidos.php");
    exit();
}
?>
<section>

    <h2>#<?php echo $pedido['id'] . ": " . $pedido['nombre'] . " " . $pedido['apellidos'] ?></h2>
    <div id="datosclientes">
        <div>
            <p><i class="fa-solid fa-id-card"></i> <?php echo $pedido['fecha']; ?></p>
            <p><i class="fa-solid fa-calendar-day"></i> <?php echo $pedido['dni']; ?></p>
            <p><i class="fa-solid fa-phone"></i> <?php echo $pedido['telefono']; ?></p>
        </div>
        <div>
            <p><i class="fa-solid fa-envelope"></i> <?php echo $pedido['correo']; ?></p>
            <p><i class="fa-solid fa-location-pin"></i> <?php echo $pedido['direccion']; ?></p>
            <p><i class="fa-solid fa-city"></i> <?php echo $pedido['poblacion']; ?>, CP: <?php echo $pedido['cp']; ?></p>
        </div>
    </div>

    <table id="myTable" class="display">
        <thead>
            <tr>
                <th>Producto</th>
                <th>Cantidad</th>
                <th>Precio</th>
                <th>SubTotal</th>
                <th>% IVA</th>
                <th>IVA</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $TOTAL = 0;
            $IVA = 0;
            $SUBTOTAL = 0;
            $ventas = $mysqli->query("SELECT ventas_detalles.*, productos.PRODUCTO, productos.unidad, productos.stock from ventas_detalles, productos where productos.id = ventas_detalles.producto and ventas_detalles.venta = " . $id);
            while ($venta = $ventas->fetch_assoc()) {
                $subtotal = $venta['precio'] * $venta['cantidad'];
                $iva = ($venta['iva'] * $subtotal) / 100;
                $iva = round($iva, 2);
                $total = $iva + $subtotal;
                $SUBTOTAL += $subtotal;
                $TOTAL += $total;
                $IVA += $iva;
                echo '<tr>
                        <td>' . $venta['PRODUCTO'] . '</td>
                        <td id="cantidad_' . $venta['id'] . '"><input onchange="cambiarCantidadCarrito(' . $venta['id'] . ', '. $id.')" type="number" name="cantidad[' . $venta['id'] . ']" required min="0" value="' . $venta['cantidad'] . '"> ' . $venta['unidad'] . '</td>
                        <td id="precio_' . $venta['id'] . '">' . $venta['precio'] . '</td>
                        <td id="subtotal_' . $venta['id'] . '">' . $subtotal . '</td>
                        <td id="piva_' . $venta['id'] . '">' . $venta['iva'] . '</td>
                        <td id="iva_' . $venta['id'] . '">' . $iva . '</td>
                        <td id="total_' . $venta['id'] . '">' . $total . '</td>
                    </tr>';
            }
            ?>

        </tbody>
        <tfoot></tfoot>

        <tr>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th>SUBTOTAL</th>
            <th id="SUBTOTAL"><?php echo $SUBTOTAL; ?></th>
        </tr>
        <tr>
            <th></th>
            <th class="ocultar"></th>
            <th class="ocultar"></th>
            <th class="ocultar"></th>
            <th class="ocultar"></th>
            <th>IVA</th>
            <th id="IVA"><?php echo $IVA; ?></th>
        </tr>


        <tr>
            <th></th>
            <th class="ocultar"></th>
            <th class="ocultar"></th>
            <th class="ocultar"></th>
            <th class="ocultar"></th>
            <th>TOTAL</th>
            <th><input class="input50" type="number" name="total" id="TOTAL" value="<?php echo $TOTAL; ?>" disabled></th>
        </tr>
        </tfoot>
    </table>

    <script>
        let table = new DataTable('#myTable', {
            "language": {
                url: '//cdn.datatables.net/plug-ins/1.13.3/i18n/es-ES.json',
            },
            "pageLength": 100,
            "order": [
                [0, 'desc'],
                [1, 'asc']
            ]
        });
    </script>

</section>

<?php include_once("abajo.php"); ?>