
function borrar(url) {
    if (confirm("¿Confirma que quiere borrar el registro?") == true) {
        location.replace(url);
    }
}


function editarProducto(id) {
    location.replace("editar_producto.php?id=" + id);
}


function editarPrecio(idproducto, seguridad, precio) {
    data = { "id": idproducto, "precio": precio, "seguridad": seguridad };
    $.ajax({
        type: "post",
        url: "includes/editar_precio.php",
        data: data,
        /* dataType: "json" */
    })
        .done(function (datos) {
            console.log(datos)
        })
        .fail(function () {
            alert("error");
        })
        .always(function () {
            //alert("complete");
        });
}


function cambiarEstado(idproducto) {
    let estado = $("#estado_" + idproducto).val();
    data = { "id": idproducto, "estado": estado };
    $.ajax({
        type: "post",
        url: "includes/editar_producto_estado.php",
        data: data,
        /* dataType: "json" */
    })
        .done(function (datos) {
            console.log(datos)
        })
        .fail(function () {
            alert("error");
        })
        .always(function () {
            //alert("complete");
        });
}


function roundToTwo(num) {
    return +(Math.round(num + "e+2") + "e-2");
}


function cambiarCantidadCarrito(id, idpedido) {
    let cantidad = $("#cantidad_" + id + " input").val();
    console.log(cantidad);
    let subtotal = parseFloat($("#precio_" + id).text()) * cantidad;
    let iva = roundToTwo((parseFloat($("#piva_" + id).text()) * subtotal) / 100);
    let total = iva + subtotal;


    $("#SUBTOTAL").text(roundToTwo(parseFloat($("#SUBTOTAL").text()) - parseFloat($("#subtotal_" + id).text()) + subtotal));
    $("#IVA").text(roundToTwo(parseFloat($("#IVA").text()) - parseFloat($("#iva_" + id).text()) + iva));
    let TOTAL = roundToTwo(parseFloat($("#TOTAL").val()) - parseFloat($("#total_" + id).text()) + total);
    $("#TOTAL").val(TOTAL);
    

    $("#subtotal_" + id).text(subtotal);
    $("#iva_" + id).text(iva);
    $("#total_" + id).text(total);

    let data = { "id": id, "cantidad": cantidad };
    $.ajax({
        type: "post",
        url: "includes/editar_cantidad_venta_detalle.php",
        data: data,
        /* dataType: "json" */
    })
        .done(function (datos) {
            console.log(datos);
        })
        .fail(function () {
            alert("error");
        })
        .always(function () {
            //alert("complete");
        });

    let data2 = { "id": idpedido, "importe": TOTAL};
    $.ajax({
        type: "post",
        url: "includes/editar_importe_pedido.php",
        data: data2,
        /* dataType: "json" */
    })
        .done(function (datos) {
            console.log(datos);
        })
        .fail(function () {
            alert("error");
        })
        .always(function () {
            //alert("complete");
        });
}
