<?php
include_once("includes/datos.php");
$title = "Su Compra";
include_once("includes/funciones.php");
$name = generarclave(5);
$seguridad = generarclave(50);
$cat = generarclave(10);
$posiciones = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9];
for ($i = 0; $i < 9; $i++) {
    $p1 = rand(0, 9);
    $p2 = rand(0, 9);
    $p = $posiciones[$p1];
    $posiciones[$p1] = $posiciones[$p2];
    $posiciones[$p2] = $p;
}
setcookie("name", $name, time() + (20 * 60), "/");
setcookie("seg", $seguridad, time() + (20 * 60), "/");
setcookie("cat", base64_encode($cat), time() + (20 * 60), "/");


?>
<?php
include_once("arriba.php");


?>
<h1><?php echo $title; ?></h1>

<?php
$carrito = [];
if (isset($_COOKIE['data'])) {
    $carrito = unserialize(base64_decode($_COOKIE['data']));
}

?>

<table id="myTable" class="display" style="max-width: 100%;">
    <thead>
        <tr>
            <th>Producto</th>
            <th>Cantidad</th>
            <th class="ocultar">Precio</th>
            <th class="ocultar">SubTotal</th>
            <th class="ocultar">% IVA</th>
            <th class="ocultar">IVA</th>
            <th>Total</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $TOTAL = 0;
        $IVA = 0;
        $SUBTOTAL = 0;
        foreach ($carrito as $key => $value) {
            $producto = $mysqli->query("select * from vista_productos where id = " . $value[0] . " limit 1");
            if ($producto->num_rows == 1) {
                $producto = $producto->fetch_assoc();
                $subtotal = $producto['precio'] * $value[1];
                $iva = ($producto['iva'] * $subtotal) / 100;
                $iva = round($iva, 2);
                $total = $iva + $subtotal;
                $SUBTOTAL += $subtotal;
                $TOTAL += $total;
                $IVA += $iva;
                echo '<tr>
                        <td>' . $producto['producto'] . '</td>
                        <td id="cantidad_' . $key, '"><input onchange="cambiarCantidadCarrito(' . $key . ')" step="' . $producto['cantidadminima'] . '" type="number" name="cantidad[' . $producto['id'] . ']" required min="0" value="' . $value[1] . '"> ' . $producto['unidad'] . '</td>
                        <td class="ocultar" id="precio_' . $key, '">' . $producto['precio'] . '</td>
                        <td class="ocultar" id="subtotal_' . $key, '">' . $subtotal . '</td>
                        <td class="ocultar" id="piva_' . $key, '">' . $producto['iva'] . '</td>
                        <td class="ocultar" id="iva_' . $key, '">' . $iva . '</td>
                        <td id="total_' . $key, '">' . $total . '</td>
                    </tr>';
            }
        }
        ?>

    </tbody>
    <tfoot></tfoot>

    <tr>
        <th></th>
        <th class="ocultar"></th>
        <th class="ocultar"></th>
        <th class="ocultar"></th>
        <th class="ocultar"></th>
        <th>SUBTOTAL</th>
        <th id="SUBTOTAL"><?php echo $SUBTOTAL; ?></th>
    </tr>
    <tr>
        <th></th>
        <th class="ocultar"></th>
        <th class="ocultar"></th>
        <th class="ocultar"></th>
        <th class="ocultar"></th>
        <th>IVA</th>
        <th id="IVA"><?php echo $IVA; ?></th>
    </tr>


    <tr>
        <th></th>
        <th class="ocultar"></th>
        <th class="ocultar"></th>
        <th class="ocultar"></th>
        <th class="ocultar"></th>
        <th>TOTAL</th>
        <th id="TOTAL"><?php echo $TOTAL; ?></th>
    </tr>
    </tfoot>
</table>

<!-- <button class="boton"><i class="fa-solid fa-pen-to-square"></i> Modificar Cesta</button> -->


<script>
    let table = new DataTable('#myTable', {
        /* responsive: true, */
        "language": {
            url: '//cdn.datatables.net/plug-ins/1.13.3/i18n/es-ES.json',
        },
  /*       columnDefs: [{
                responsivePriority: 1,
                targets: 0
            },
            {
                responsivePriority: 10001,
                targets: 1
            },
            {
                responsivePriority: 10001,
                targets: 2
            },
            {
                responsivePriority: 10001,
                targets: 3
            },
            {
                responsivePriority: 10001,
                targets: 4
            },
            {
                responsivePriority: 3,
                targets: 5
            },
            {
                responsivePriority: 4,
                targets: 6
            }
        ], */
        "pageLength": 100,
        "order": [
            [0, 'desc'],
            [1, 'asc']
        ]
    });
</script>

<form action="guardarpedido.php" method="post">
    <fieldset>
        <legend>Hacer Pedido</legend>
        <input type="hidden" name="<?php echo $name; ?>" value="<?php echo base64_encode($seguridad); ?>">
        <input type="hidden" name="p[]" value="<?php echo $posiciones[0]; ?>">
        <input type="hidden" name="p[]" value="<?php echo $posiciones[1]; ?>">
        <input type="hidden" name="p[]" value="<?php echo $posiciones[2]; ?>">
        <input type="hidden" name="p[]" value="<?php echo $posiciones[3]; ?>">
        <input class="input input100" type="text" name="nombre" required maxlength="150" placeholder="Su Nombre:">
        <input class="input input100" type="text" name="apellidos" required maxlength="150" placeholder="Apellidos:">
        <input class="input input50" type="text" name="dni" required maxlength="15" placeholder="DNI/CIF:">
        <input class="input input100" type="text" name="direccion" required maxlength="250" placeholder="Dirección:">
        <input class="input input50" type="number" name="telefono" required maxlength="10" placeholder="Teléfono:">
        <input class="input input100" type="email" name="mail" required maxlength="200" placeholder="Correo:">
        <select class="input input100" name="provincia" id="selectprovincias" required onchange="localidades()">
            <option value="">Provincias</option>
            <?php
            $provincias = $mysqli->query("SELECT * from provincias order by provincia asc");
            while ($provincia = $provincias->fetch_assoc()) {
                echo '<option value="' . $provincia['id'] . '">' . $provincia['provincia'] . '</option>';
            }
            ?>
        </select>
        <div class="nomostrar cargando"><i class="fa-solid fa-spinner fa-spin-pulse"></i></div>
        <select class="input input50" name="localidad" required id="seleclocalidades">
            <option value="">Localidades</option>
        </select>
        <input type="text" name="cp" class="input input50" required minlength="5" maxlength="5" placeholder="Código Postal">
        <table border="1">
            <tr>
                <td>Posiciones:</td>
                <?php
                for ($i = 0; $i <= 9; $i++) {
                    echo "<td>" . $i . "</td>";
                }
                ?>
            </tr>
            <tr>
                <td></td>
                <?php
                for ($i = 0; $i <= 9; $i++) {
                    echo "<td>" . $cat[$i] . "</td>";
                }
                ?>
            </tr>
        </table>
        <p>
            Introducca las posiciones <?php echo $posiciones[0] . " " . $posiciones[1] . " " . $posiciones[2] . " " . $posiciones[3]; ?>
            <input class="input input20" type="text" name="seguridad" required maxlength="4" minlength="4">
        </p>

        <button class='boton'><i class="fa-solid fa-truck-moving"></i> Hacer Pedido</button>

        <p><input type="checkbox" name="privacidad" value="1" required> Acepta la política de Privacidad de Datos</p>
    </fieldset>
</form>

<?php
include_once("abajo.php");
?>