<?php
class Carton
{
    private $todoslosnumeros = [];
    private  $contador = 0;
    private  $numeros = [];
    private  $numerosp = [];

    //método de la burbuja
    private function ordenarArray($array)
    {
        for ($i = 0; $i < count($array) - 1; $i++) {
            if ($array[$i] > $array[$i + 1]) {
                $intercambio = $array[$i];
                $array[$i] = $array[$i + 1];
                $array[$i + 1] = $intercambio;
                $i = -1;
            }
        }
        return $array;
    }


    public function __construct()
    {
        for ($f = 0; $f <= 8; $f++) {
            for ($c = 0; $c <= 9; $c++) {
                $this->todoslosnumeros[$f][$c] = $this->contador++;
            }
        }

        //pillamos 3 números de cada decena no repetidos
        for ($f = 0; $f < 3; $f++) {
            for ($decena = 0; $decena < 9; $decena++) {
                $key = rand(0, (9 - $f));
                $this->numeros[] = $this->todoslosnumeros[$decena][$key];
                $this->numerosp[$f][$decena] = -1;
                $this->todoslosnumeros[$decena][$key] = $this->todoslosnumeros[$decena][9 - $f];
                $this->todoslosnumeros[$decena][9 - $f] = $this->numeros[count($this->numeros) - 1];
            }
        }



        $this->numeros = $this->ordenarArray($this->numeros);



        //Colocamos todos los números en el cartón
        $this->contador = 0;
        for ($i = 0; $i < 26; $i += 3) {
            $this->numerosp[0][$this->contador] = $this->numeros[$i];
            $this->numerosp[1][$this->contador] = $this->numeros[$i + 1];
            $this->numerosp[2][$this->contador++] = $this->numeros[$i + 2];
        }


        //print_r($this->numerosp);

        //Tachamos 4 números de las dos primeras filas
        for ($f = 0; $f < 2; $f++) {
            $tachados = 0;
            while ($tachados < 4) {
                $key = rand(0, 8);
                if ($this->numerosp[$f][$key] != -1) {
                    $this->numerosp[$f][$key] = -1;
                    $tachados++;
                }
            }
        }

        //print_r($this->numerosp);

        //Tachamos los 4 de la últimas fila, bucle da cueltas hasta pillar 4 tachados sin que en las dos filas anteriores estén en la columna ya dos tachados
        $tachados = 0;
        while ($tachados < 4) {
            $key = rand(0, 8);
            //echo $key . "-";
            if ((($this->numerosp[0][$key] != -1) || ($this->numerosp[1][$key] != -1)) && ($this->numerosp[2][$key] != -1)) {
                //echo $key . "<br>";
                $this->numerosp[2][$key] = -1;
                $tachados++;
            }
        }
        $this->numeros = $this->numerosp;
    }


    public function tachar($numero)
    {
        for ($f = 0; $f < 3; $f++) {
            for ($c = 0; $c < 9; $c++) {
                if (intval($this->numerosp[$f][$c]) == intval($numero)) {
                    $this->numerosp[$f][$c] = -1;
                    return;
                }
            }
        }
    }


    public function buscarLinea()
    {
        for ($f = 0; $f < 3; $f++) {
            $linea = 0;
            for ($c = 0; $c < 9; $c++) {
                if ($this->numerosp[$f][$c] == -1) {
                    $linea++;
                }
            }
            if ($linea == 9) {
                return true;
            }
        }
        return false;
    }


    public function buscarBingo()
    {
        $bingo = 0;
        for ($f = 0; $f < 3; $f++) {
            for ($c = 0; $c < 9; $c++) {
                if ($this->numerosp[$f][$c] == -1) {
                    $bingo++;
                }
            }
            if ($bingo == 27) {
                return true;
            }
        }
        return false;
    }



    //Pintamos la tabla de 3filas por 9 columanas recorriendo el arrya numerosp
    public function pintarCarton()
    {
        echo "<table>";
        for ($f = 0; $f < 3; $f++) {
            echo "<tr>";
            for ($c = 0; $c < 9; $c++) {
                if ($this->numeros[$f][$c] == -1) {
                    echo "<td><img src='https://alfonso.ciberweb.com/php/arrays/bingo/bingo.png'></td>";
                } else {
                    echo "<td>" . $this->numeros[$f][$c] . "</td>";
                }
            }
            echo "</tr>";
        }
        echo "</table>";
    }


    //Pintamos la tabla de 3filas por 9 columanas recorriendo el arrya numerosp
    public function pintarCartonTachados()
    {
        echo "<table>";
        for ($f = 0; $f < 3; $f++) {
            echo "<tr>";
            for ($c = 0; $c < 9; $c++) {
                if ($this->numerosp[$f][$c] == -1) {
                    echo "<td><img src='https://alfonso.ciberweb.com/php/arrays/bingo/bingo.png'></td>";
                } else {
                    echo "<td>" . $this->numeros[$f][$c] . "</td>";
                }
            }
            echo "</tr>";
        }
        echo "</table>";
    }
}



function password()
{
    $palabra = "";
    $array = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 1, 2, 3, 4, 5, 6, 7, 8, 9];
    for ($i=0; $i < 10; $i++) { 
        $palabra .= $array[rand(0, count($array) - 1)];
    }
    return $palabra;
}
