<?php
require_once("./datos/clases.php");
?>
<!DOCTYPE HTML>
<html>

<head>
	<title>Bus la Rapida</title>
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no" />
	<link rel="stylesheet" href="assets/css/main.css" />
</head>

<body>
	<div id="page-wrapper">

		<!-- Header -->
		<div id="header-wrapper">
			<div class="container">
				<div class="row">
					<div class="col-12">

						<header id="header">
							<h1><a href="index.php" id="logo">La Rapida</a></h1>
							<nav id="nav">
								<a href="index.php" class="current-page-item">Lineas</a>
								<a href="venta.php">Venta</a>
							</nav>
						</header>

					</div>
				</div>
			</div>
		</div>

		<!-- Main -->
		<div id="main">
			<div class="container">
				<div class="row main-row">
					<div class="col-8 col-12-medium">

						<section>
							<h2>Gestionar Líneas</h2>
							<p>
							<form action="datos/nuevalinea.php" method="post">
								<input type="text" name="ruta" required>
								<input type="number" name="cantidad" min="1" max="10" required id="cantidadBuses" onchange="inputBuses();">
								<div id="buses">

								</div>

								<input type="submit" value="Crear Ruta">
							</form>
							</p>
						</section>

					</div>
					<div class="col-4 col-12-medium">

						<section>
							<h2>Rutas Del día</h2>
							<ul class="small-image-list">
								<?php
								$rutas = [];
								if (file_exists(__DIR__ . "/datos/rutas.txt")) {
									$rutas = unserialize(file_get_contents(__DIR__ . "/datos/rutas.txt"));
									if (count($rutas) > 0) {
										foreach ($rutas as $key => $value) {
								?>
											<li>
												<a href="venta.php?key=<?php echo $key; ?>"><img src="images/ruta_bus.png" alt="" class="left" />
													<h4><?php echo $value->getRuta(); ?></h4>
													<p>Tiene <?php echo $value->getCantidadBuses(); ?> de bus</p>
												</a>
											</li>
								<?php
										}
									}
								}
								?>
							</ul>
						</section>


					</div>
				</div>
			</div>
		</div>

		<!-- Footer -->
		<div id="footer-wrapper">
			<div class="container">
				<div class="row">
					<div class="col-8 col-12-medium">

						<section>
							<h2>How about a truckload of links?</h2>
							<div>
								<div class="row">
									<div class="col-3 col-6-medium col-12-small">
										<ul class="link-list">
											<li><a href="#">Sed neque nisi consequat</a></li>
											<li><a href="#">Dapibus sed mattis blandit</a></li>
											<li><a href="#">Quis accumsan lorem</a></li>
											<li><a href="#">Suspendisse varius ipsum</a></li>
											<li><a href="#">Eget et amet consequat</a></li>
										</ul>
									</div>
									<div class="col-3 col-6-medium col-12-small">
										<ul class="link-list">
											<li><a href="#">Quis accumsan lorem</a></li>
											<li><a href="#">Sed neque nisi consequat</a></li>
											<li><a href="#">Eget et amet consequat</a></li>
											<li><a href="#">Dapibus sed mattis blandit</a></li>
											<li><a href="#">Vitae magna sed dolore</a></li>
										</ul>
									</div>
									<div class="col-3 col-6-medium col-12-small">
										<ul class="link-list">
											<li><a href="#">Sed neque nisi consequat</a></li>
											<li><a href="#">Dapibus sed mattis blandit</a></li>
											<li><a href="#">Quis accumsan lorem</a></li>
											<li><a href="#">Suspendisse varius ipsum</a></li>
											<li><a href="#">Eget et amet consequat</a></li>
										</ul>
									</div>
									<div class="col-3 col-6-medium col-12-small">
										<ul class="link-list">
											<li><a href="#">Quis accumsan lorem</a></li>
											<li><a href="#">Sed neque nisi consequat</a></li>
											<li><a href="#">Eget et amet consequat</a></li>
											<li><a href="#">Dapibus sed mattis blandit</a></li>
											<li><a href="#">Vitae magna sed dolore</a></li>
										</ul>
									</div>
								</div>
							</div>
						</section>

					</div>
					<div class="col-4 col-12-medium">

						<section>
							<h2>Something of interest</h2>
							<p>Duis neque nisi, dapibus sed mattis quis, rutrum accumsan sed.
								Suspendisse eu varius nibh. Suspendisse vitae magna eget odio amet
								mollis justo facilisis quis. Sed sagittis mauris amet tellus gravida
								lorem ipsum dolor sit blandit.</p>
							<footer class="controls">
								<a href="#" class="button">Oh, please continue ....</a>
							</footer>
						</section>

					</div>
				</div>
				<div class="row">
					<div class="col-12">

						<div id="copyright">
							&copy; Untitled. All rights reserved. | Design: <a href="http://html5up.net">HTML5 UP</a>
						</div>

					</div>
				</div>
			</div>
		</div>

	</div>

	<!-- Scripts -->
	<script src="assets/js/jquery.min.js"></script>
	<script src="assets/js/browser.min.js"></script>
	<script src="assets/js/breakpoints.min.js"></script>
	<script src="assets/js/util.js"></script>
	<script src="assets/js/main.js"></script>
	<script src="assets/js/js.js"></script>
</body>

</html>