<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

class Ruta 
{
    private $ruta;
    private $cantidad;
    private $buses = [];

    public function __construct($ruta, $cantidad, $arrayAsientos, $arrayMatriculas)
    {
        $this->ruta = $ruta;
        $this->cantidad = $cantidad;
        for ($i=0; $i < $cantidad; $i++) { 
            $this->buses[$i] = new Bus($arrayMatriculas[$i], $arrayAsientos[$i]);
        }
    }

    public function getRuta(){
        return $this->ruta;
    }

    public function getCantidadBuses(){
        return $this->cantidad;
    }

    public function pintarBuses(){
        for ($key=0; $key < $this->cantidad; $key++) { 
            echo "<h2>Bus " . $key . "</h2>";
            $this->buses[$key]->pintar($key);
        }
    }

    public function VenderTicket($keybus, $nasiento){
        $this->buses[$keybus]->venderAsiento($nasiento);
    }
    
}



class Bus 
{
    private $matricula;
    private $asientos = [];

    public function __construct($matricula, $cantidadAsientos)
    {
        $this->matricula = $matricula;
        for ($i=0; $i < $cantidadAsientos; $i++) { 
            $this->asientos[$i] = false;
        }
    }

    public function pintar($bus = 0){
        echo "<table class='blueTable'>";
        for ($f=0; $f < 4 ; $f++) { 
            echo "<tr>";
            for ($a=$f; $a < count($this->asientos); $a+=4) { 
                if($this->asientos[$a] == false){
                    echo '<td><label>' . $a . ': <input type="checkbox" name="asiento[' . $bus . '][' . $a .']" value="true"></label></td>';
                } else {
                    echo "<td><img class='ocupado' src='https://alfonso.ciberweb.com/php/poo/bus/intranet/images/ocupado.png'></td>";
                }
            }
            echo "</tr>";
        }
        echo "</table>";
    }

    public function venderAsiento($nasiento){
        $this->asientos[$nasiento] = true;
    }
}
?>