<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bombo del Bingo</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto+Mono&display=swap');

        :root {
            background-color: whitesmoke;
        }

        body form {
            display: grid;
            grid-template-columns: 1fr 1fr 1fr 1fr 1fr;
            grid-template-areas: 'numero numero tabla tabla tabla';
        }

        #numero {
            grid-area: numero;
            text-align: center;
        }

        #numero p {
            display: block;
            text-align: center;
            font-size: 15em;
            color: white;
            background-color: blue;
        }

        table {
            grid-area: tabla;
            color: whitesmoke;
            font-family: 'Roboto Mono', monospace;
            border: 8px blue double;
            border-collapse: collapse;
            border-radius: 9px;
            margin: auto;
            -webkit-box-shadow: 0px 0px 6px 1px rgba(0, 0, 0, 0.75);
            -moz-box-shadow: 0px 0px 6px 1px rgba(0, 0, 0, 0.75);
            box-shadow: 0px 0px 6px 1px rgba(0, 0, 0, 0.75);
            background-color: white;
        }

        td {
            width: 40px;
            height: 40px;
            border: 1px blue solid;
            text-align: center;
            font-size: 2em;
            padding: 6px;
        }

        td img {
            max-width: 55px;
        }

        caption {
            text-align: left;
        }

        .rojo {
            color: red;
        }
    </style>
</head>

<body>
    <?php
    $numeros = []; //este array vale para tal cosas
    $bombo = [];
    $bola = -1;
    if (isset($_POST['numero'])) {
        $bombo = $_POST['numero'];
        for ($i = 0; $i < 90; $i++) {
            if ($bombo[$i] == 0) {
                $numeros[] = $i;
            }
        }
        if (count($numeros) > 0) {
            $bola = rand(0, count($numeros) - 1);
            $bombo[$numeros[$bola]] = 1;
        }
    } else {
        for ($i = 0; $i < 90; $i++) {
            $bombo[$i] = 0;
        }
    }
    ?>

    <form action="bombophp.php" method="post">
        <table>
            <?php
            $n = 0;
            for ($f = 0; $f < 9; $f++) {
                echo "<tr>";
                for ($c = 0; $c <= 9; $c++) {
                    //$n = (($c * 10) + $f);
                    $hasalido = $bombo[$n];
                    $clase = "";
                    if ($bombo[$n] == 1) {
                        $clase = "rojo";
                    }
                    $td = "<td class='${clase}' id='numero_${n}'>${n}<input type='hidden' name='numero[${n}]' value='${hasalido}'></td>";
                    echo $td;
                    $n++;
                }
                echo "</tr>";
            }
            ?>
        </table>



        <div id="numero">
            <p>
                <?php
                if ($bola >= 0) {
                    echo $numeros[$bola];
                }
                ?>
            </p>
            <?php
                if (!(isset($_POST['numero'])) || count($numeros) > 0) {
                    echo '<button accesskey="c" type="submit">Sacar Bola</button>&nbsp;';
                }
                ?>
            
            <a href="bombophp.php">Empezar Nuevo Bingo</a>
        </div>
    </form>

</body>

</html>