<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bombo del Bingo</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto+Mono&display=swap');

        :root {
            background-color: whitesmoke;
        }

        body {
            display: grid;
            grid-template-columns: 1fr 1fr 1fr 1fr 1fr;
            grid-template-areas: 'numero numero tabla tabla tabla';
        }
        #numero{
            grid-area: numero;
            text-align: center;
        }

        #numero p{
            display: block;
            text-align: center;
            font-size: 15em;
            color: white;
            background-color: blue;
        }

        table {
            grid-area: tabla;
            color: whitesmoke;
            font-family: 'Roboto Mono', monospace;
            border: 8px blue double;
            border-collapse: collapse;
            border-radius: 9px;
            margin: auto;
            -webkit-box-shadow: 0px 0px 6px 1px rgba(0, 0, 0, 0.75);
            -moz-box-shadow: 0px 0px 6px 1px rgba(0, 0, 0, 0.75);
            box-shadow: 0px 0px 6px 1px rgba(0, 0, 0, 0.75);
            background-color: white;
        }

        td {
            width: 40px;
            height: 40px;
            border: 1px blue solid;
            text-align: center;
            font-size: 2em;
            padding: 6px;
        }

        td img {
            max-width: 55px;
        }

        caption {
            text-align: left;
        }
    </style>
    <!-- <script src="https://code.jquery.com/jquery-3.6.0.js"></script> -->
    <script>
        let numeros = [];
        let sacados = 0; //un contador de números utilizados
        for (let n = 0; n <= 89; n++) {
            numeros[n] = n;
        }
        console.log(numeros);

        function sacarbola() {
            let key = aleatorio(0, (89 - sacados));
            let numero = numeros[key];
            document.getElementById("numero_" + numero).style.color = "red";
            document.querySelector("#numero p").innerHTML = numero;
            /* $("#numero_" + numero).css('color', 'red');
            $("#numero p").html(numero); */
            let pivote = numero;
            numeros[key] = numeros[89 - sacados];
            numeros[89 - sacados] = pivote;
            sacados++;
        }

        function aleatorio(min, max) {
            return Math.floor(Math.random() * (max - min)) + min;
        }
    </script>
</head>

<body>
    <table>
        <?php
        for ($f = 0; $f <= 9; $f++) {
            echo "<tr>";
            for ($c = 0; $c < 9; $c++) {
                $n = (($c * 10) + $f);
                echo "<td id='numero_" . $n . "'>" . $n . "</td>";
            }
            echo "</tr>";
        }
        ?>
    </table>
    
    <div id="numero">
        <p>&nbsp;</p>
        <button accesskey="c" onclick="sacarbola();">Sacar Bola</button>
    </div>
    
</body>

</html>