<?php
if (isset($_GET['c']) && $_GET['c'] == -1) {
    header("Location: post.php");
    exit();
}

$categorias_cantidades = [];
$categorias = unserialize(file_get_contents(__DIR__ . "/includes/datos/categorias.txt"));
$posts = unserialize(file_get_contents(__DIR__ . "/includes/datos/posts.txt"));

foreach ($posts as $key => $value) {
    $categorias_cantidades[$value['categoria']]++;
}
$title = "Listado de Artículos Publicados...";

if (isset($_GET['c']) && $_GET['c'] >= 0) {
    $title = "Listado de Artículos: " . $categorias[$_GET['c']];
}


?>
<?php include_once("includes/arriba.php"); ?>

<section class="formularios">
    <div class="derecha">
        <a href="post.php"><i class="fa-solid fa-filter-circle-xmark"></i></a>
    </div>    
    <form action="post.php" method="get">
        <select name="c" required>
            <option value="-1">Categorías</option>
            <?php
            foreach ($categorias_cantidades as $key => $value) {
                $selected = "";
                if (isset($_GET['c']) && ($_GET['c'] == $key)) {
                    $selected = "selected";
                }
                echo '<option ' . $selected . ' value="' . $key . '">' . $categorias[$key] . '</option>';
            }
            ?>
        </select>
        <button type="submit"><i class="fa-solid fa-filter"></i> Filtrar</button>
    </form>
</section>

<section>
    <ul class="lista">
        <?php
        $posts = unserialize(file_get_contents(__DIR__ . "/includes/datos/posts.txt"));
        if (count($posts) > 0) {
            $keys = array_keys($posts);
            $keys = array_reverse($keys);
            foreach ($keys as $key => $value) {
                if (isset($_GET['c']) && $_GET['c'] >= 0) {
                    if ($_GET['c'] == $posts[$value]['categoria']) {
                        echo '<li><i onclick="borrar_post(\'' . $value . '\')" class="fa-solid fa-trash rojo"></i> <a href="editar_post.php?key=' . $value . '">' . $posts[$value]['titulo'] . '</a></li>';
                    }
                } else {
                    echo '<li><i onclick="borrar_post(\'' . $value . '\')" class="fa-solid fa-trash rojo"></i> <a href="editar_post.php?key=' . $value . '">' . $posts[$value]['titulo'] . '</a></li>';
                }
            }
        } else {
            echo '<span class="alerta"><i class="fa-solid fa-circle-exclamation"></i> No hay POSTS, publicado, publice un post</span>';
        }
        ?>
    </ul>
</section>


<?php include_once("includes/abajo.php"); ?>