<?php
$post = [];
if (isset($_GET['key'])) {
    $post = unserialize(file_get_contents(__DIR__ . "/includes/datos/posts/" . $_GET['key'] . ".txt"));
    if (!isset($post['titulo'])) {
        header("Location: post.php");
        exit();
    }
} else {
    header("Location: post.php");
    exit();
}
$title = "Editar: " . $post['titulo'];
?>
<?php include_once("includes/arriba.php"); ?>

<section class="formularios">
    <?php
    if (isset($_GET['ok']) && $_GET['ok'] == 1) {
        echo '<span class="alerta_ok"><i class="fa-solid fa-thumbs-up"></i> Se ha guardado correctamente</span>';
    }
    ?>

    <form action="includes/editar_post.php" method="post">
        <input type="text" name="titulo" placeholder="Título: " required max="250" value="<?php echo $post['titulo'] ?>">
        <input type="text" name="resumen" placeholder="Introducción: " required max="250" value="<?php echo $post['resumen'] ?>">
        <input type="text" name="url" placeholder="URL Amigable: " required max="250" value="<?php echo $post['key'] ?>" readonly>
        <input type="url" name="imagen" placeholder="Imagen Presentación: " required max="250" value="<?php echo $post['imagen'] ?>">
        <select name="categoria" required>
            <option value="0">Categorías</option>
            <?php
            $categorias = unserialize(file_get_contents(__DIR__ . "/includes/datos/categorias.txt"));
            foreach ($categorias as $key => $value) {
                $selected = "";
                if ($key == $post['categoria']) {
                    $selected = "selected";
                }
                echo '<option ' . $selected . ' value="' . $key . '">' . $value . '</option>';
            }
            ?>
        </select>
        <textarea name="contenido" required><?php echo $post['contenido']; ?></textarea>
        <input type="submit" value="Editar Post">
    </form>
</section>


<?php include_once("includes/abajo.php"); ?>