<?php
$title = "Categorías";
?>
<?php include_once("includes/arriba.php"); ?>

<section class="formularios">
    <form action="includes/nueva_categoria.php" method="post">
        <input type="text" name="categoria" placeholder="Categoría: " required>
        <input type="submit" value="Nueva Categoría">
    </form>
</section>

<section>
    <ul class="lista">
        <?php
        $categorias_cantidades = [];
        $categorias = unserialize(file_get_contents(__DIR__ . "/includes/datos/categorias.txt"));
        $posts = unserialize(file_get_contents(__DIR__ . "/includes/datos/posts.txt"));

        foreach ($posts as $key => $value) {
            $categorias_cantidades[$value['categoria']]++;
        }

        foreach ($categorias as $key => $value) {
            echo "<li>";
            if (!isset($categorias_cantidades[$key])) {
                echo "<i onclick='borrar_categoria(" . $key . ")' class='fa-solid fa-trash rojo'></i> ";
            } else {
                echo "(" . $categorias_cantidades[$key] . ")";
            }
        ?>
            <form action="includes/editar_categoria.php" method="post">
                <input type="text" name="categoria" value="<?php echo $value; ?>" required>
                <input type="hidden" name="key" value="<?php echo $key; ?>">
                <button><i class="fa-solid fa-pen-to-square"></i></button>
            </form>
            </li>
        <?php
        }
        ?>
    </ul>
</section>



<?php include_once("includes/abajo.php"); ?>